/* vk.h -- Windows Virtual Key Codes */

#define VK_LBUTTON  0x01
#define VK_RBUTTON  0x02
#define VK_CANCEL   0x03
#define VK_MBUTTON  0x04    /* NOT contiguous with L & RBUTTON */
#define VK_BACK     0x08
#define VK_TAB	    0x09
#define VK_CLEAR    0x0c
#define VK_RETURN   0x0d
#define VK_SHIFT    0x10
#define VK_CONTROL  0x11
#define VK_MENU     0x12
#define VK_PAUSE    0x13
#define VK_CAPITAL  0x14
#define VK_ESCAPE   0x1b
#define VK_SPACE    0x20

#define VK_PRIOR    0x21
#define VK_NEXT     0x22
#define VK_END	    0x23
#define VK_HOME     0x24
#define VK_LEFT     0x25
#define VK_UP	    0x26
#define VK_RIGHT    0x27
#define VK_DOWN     0x28

/* VK_A thru VK_Z are the same as their ASCII equivalents: 'A' thru 'Z' */
/* VK_0 thru VK_9 are the same as their ASCII equivalents: '0' thru '0' */

#define VK_SELECT   0x29
#define VK_PRINT    0x2a
#define VK_EXECUTE  0x2b
#define VK_INSERT   0x2d
#define VK_DELETE   0x2e
#define VK_HELP     0x2f

#define VK_NUMPAD0  0x60
#define VK_NUMPAD1  0x61
#define VK_NUMPAD2  0x62
#define VK_NUMPAD3  0x63
#define VK_NUMPAD4  0x64
#define VK_NUMPAD5  0x65
#define VK_NUMPAD6  0x66
#define VK_NUMPAD7  0x67
#define VK_NUMPAD8  0x68
#define VK_NUMPAD9  0x69
#define VK_MULTIPLY 0x6A
#define VK_ADD	    0x6B
#define VK_SEPARATOR 0x6C
#define VK_SUBTRACT 0x6D
#define VK_DECIMAL  0x6E
#define VK_DIVIDE   0x6F

#define VK_F1	    0x70
#define VK_F2	    0x71
#define VK_F3	    0x72
#define VK_F4	    0x73
#define VK_F5	    0x74
#define VK_F6	    0x75
#define VK_F7	    0x76
#define VK_F8	    0x77
#define VK_F9	    0x78
#define VK_F10	    0x79
#define VK_F11	    0x7a
#define VK_F12	    0x7b
#define VK_F13	    0x7c
#define VK_F14	    0x7d
#define VK_F15	    0x7e
#define VK_F16	    0x7f
